<?php
require_once '../config.php';
require_once '../security.php';

header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['error' => 'Method not allowed']);
    exit;
}

$data = json_decode(file_get_contents('php://input'), true);

if (!Security::verifyCSRFToken($data['csrf_token'] ?? '')) {
    http_response_code(403);
    echo json_encode(['error' => 'CSRF token invalid']);
    exit;
}

$ip = $_SERVER['REMOTE_ADDR'];
$phone = Security::sanitizeInput($data['phone'] ?? '');
$timestamp = $data['timestamp'] ?? time();

// Log login attempt (in production, log to database)
$logEntry = [
    'ip' => $ip,
    'phone' => $phone,
    'timestamp' => $timestamp,
    'user_agent' => $_SERVER['HTTP_USER_AGENT'] ?? '',
    'success' => true
];

// In production, save to database
// file_put_contents('logs/login.log', json_encode($logEntry) . PHP_EOL, FILE_APPEND);

echo json_encode(['success' => true]);
?>